<?php
/*
Plugin Name: Products Without ID Manager
Description: Shows products without ID and provides direct edit buttons
Version: 1.1
Author: مصطفی نور
*/

// Add submenu under WooCommerce
add_action('admin_menu', 'pwid_add_menu_item');
function pwid_add_menu_item() {
    add_submenu_page(
        'woocommerce',
        'محصولات بدون شناسه',
        'محصولات بدون شناسه',
        'manage_woocommerce',
        'products-without-id',
        'pwid_display_page'
    );
}

// Display page content
function pwid_display_page() {
    global $wpdb;
    
    // بدست آوردن تمام محصولات بدون SKU با استفاده از کوئری مستقیم
    $query = "
        SELECT p.ID, p.post_title 
        FROM {$wpdb->posts} p 
        LEFT JOIN {$wpdb->postmeta} pm ON (p.ID = pm.post_id AND pm.meta_key = '_sku')
        WHERE p.post_type = 'product' 
        AND p.post_status = 'publish'
        AND (pm.meta_value IS NULL OR pm.meta_value = '')
    ";
    
    $products_without_sku = $wpdb->get_results($query);
    ?>
    <div class="wrap">
        <h1>محصولات بدون شناسه</h1>
        
        <?php if (!empty($products_without_sku)) : ?>
            <p>تعداد کل محصولات بدون شناسه: <?php echo count($products_without_sku); ?></p>
            
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>شناسه محصول</th>
                        <th>نام محصول</th>
                        <th>قیمت</th>
                        <th>وضعیت موجودی</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products_without_sku as $product_data) : 
                        $product = wc_get_product($product_data->ID);
                        if (!$product) continue;
                    ?>
                        <tr>
                            <td><?php echo $product->get_id(); ?></td>
                            <td><?php echo $product->get_name(); ?></td>
                            <td><?php 
                                $price = $product->get_price();
                                echo empty($price) ? 'بدون قیمت' : wc_price($price); 
                            ?></td>
                            <td><?php 
                                echo $product->get_stock_status() === 'instock' ? 'موجود' : 'ناموجود';
                            ?></td>
                            <td>
                                <a href="<?php echo get_edit_post_link($product->get_id()); ?>" 
                                   class="button button-primary">
                                    ویرایش محصول
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
        <?php else: ?>
            <div class="notice notice-success">
                <p>تبریک! هیچ محصول بدون شناسه‌ای یافت نشد.</p>
            </div>
        <?php endif; ?>
    </div>
    <?php
}

// Add custom styles
add_action('admin_head', 'pwid_admin_styles');
function pwid_admin_styles() {
    ?>
    <style>
        .products-without-id-table {
            margin-top: 20px;
        }
        .products-without-id-table .button {
            margin: 0 5px;
        }
    </style>
    <?php
}